/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Utils {
    private static final String ZERO_STRING = "0000-00-00 00:00:00.000";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd' 'HH:mm:ss.SSS");

    public static String timestampToString(Timestamp ts) {
        if (ts == null) {
            return ZERO_STRING;
        }
        return ts.toLocalDateTime().format(FORMATTER);
    }

    public static Timestamp stringToTimestamp(String str) {
        if (str == null || str.isEmpty() || ZERO_STRING.equals(str)) {
            return null;
        }
        LocalDateTime ldt = LocalDateTime.parse(str, FORMATTER);
        return Timestamp.valueOf(ldt);
    }

    public static String bigIntegerToFixedString(BigInteger value) {
        String s;
        if (value == null) {
            value = BigInteger.ZERO;
        }
        if ((s = value.toString()).length() > 16) {
            throw new IllegalArgumentException("Value too large for 16-character field: " + s);
        }
        return String.format("%016d", value);
    }

    public static BigInteger fixedStringToBigInteger(String s) {
        if (s == null || s.isEmpty()) {
            return BigInteger.ZERO;
        }
        if (s.length() != 16 || !s.matches("\\d{16}")) {
            throw new IllegalArgumentException("Invalid fixed-length BigInteger string: " + s);
        }
        return new BigInteger(s);
    }
}

